
//// change these to suit the application ////

#define IR_PIN_PORT  A
#define IR_INPUT_PIN 0
#define IR_CN_PIN    2
#define IR_AN_PIN    0
#define IR_TIMER     2
#define CRYSTAL_HZ   8000000

//////////////////////////////////////////////

#include "p33Fxxxx.h"
#include "infrared.h"

#define IR_TIMER_DIV 64

#define _TRISname(port,pin) TRIS##port##bits.TRIS##port##pin
#define TRISname(port,pin) _TRISname(port,pin)
#define _PORTname(port,pin) PORT##port##bits.R##port##pin
#define PORTname(port,pin) _PORTname(port,pin)
#define _CNname(pin) CN##pin##IE
#define CNname(pin) _CNname(pin)
#define _PCFGname(pin) PCFG##pin
#define PCFGname(pin) _PCFGname(pin)
#define _TCONname(which) T##which##CONbits
#define TCONname(which) _TCONname(which)
#define _TIMERname(which) TMR##which
#define TIMERname(which) _TIMERname(which)
#define _TMRname(which) _T##which##Interrupt
#define TMRname(which) _TMRname(which)
#define _TEname(which) IEC0bits.T##which##IE
#define TEname(which) _TEname(which)
#define _TFname(which) IFS0bits.T##which##IF
#define TFname(which) _TFname(which)
#define _PRname(which) PR##which
#define PRname(which) _PRname(which)

unsigned short rc5_code, rc5_timing, last_rc5_code;
#ifdef SUPPORT_NEC
unsigned short last_NEC_code;
unsigned long NEC_code;
#endif
unsigned char ir_bit, rc5_reset_timer;
volatile unsigned long ir_final_code;

unsigned short RC5_MIN, RC5_MAX;
unsigned char ir_CLKDIV_cache, ir_PLLFBD_cache;
#ifdef SUPPORT_NEC
unsigned short NEC_startpulse_min, NEC_startpulse_max, NEC_startpulse;
#endif

static void calc_rc5_timing() {
	unsigned long timer_hz = (unsigned long)CRYSTAL_HZ / (CLKDIVbits.PLLPRE+2) * (PLLFBD+2) / ((CLKDIVbits.PLLPOST+1)*4*IR_TIMER_DIV);
	unsigned short rc5_cycles = timer_hz / 1125;
#ifdef SUPPORT_NEC
	unsigned short timer_khz = timer_hz / 500;
#endif
	RC5_MIN = rc5_cycles * 2 * 3 / 4;
	RC5_MAX = rc5_cycles * 2 * 4 / 3;

#ifdef SUPPORT_NEC
	NEC_startpulse = timer_khz * 4;
	NEC_startpulse_min = NEC_startpulse * 3 / 4;
	NEC_startpulse_max = NEC_startpulse * 4 / 3;
#endif

	ir_CLKDIV_cache = CLKDIV;
	ir_PLLFBD_cache = PLLFBD;
}

void init_ir() {
	TRISname(IR_PIN_PORT,IR_INPUT_PIN) = 1;
#ifdef IR_AN_PIN
	AD1PCFGLbits.PCFGname(IR_AN_PIN) = 1;
#endif
#if IR_CN_PIN <= 15
	CNEN1bits.CNname(IR_CN_PIN) = 1;
#else
	CNEN2bits.CNname(IR_CN_PIN) = 1;
#endif
	IEC1bits.CNIE = 1;

	TCONname(IR_TIMER).TCKPS = 2; // master clock divided by 64
	TEname(IR_TIMER) = 1;
	calc_rc5_timing();
}

inline static void start_ir_timer() {
	TIMERname(IR_TIMER) = 0;
	TCONname(IR_TIMER).TON = 1;
}

inline static void stop_ir_timer() {
	TCONname(IR_TIMER).TON = 0;
}

inline static void cancel_rc5_reception() {
	stop_ir_timer();
	ir_bit = 0;
}

void __attribute__((__interrupt__,no_auto_psv)) TMRname(IR_TIMER)( void ) {
	TFname(IR_TIMER) = 0;
#ifdef SUPPORT_NEC
	if( ir_bit == 1 || ir_bit == 31 || rc5_reset_timer ) {
#else
	if( ir_bit == 1 || rc5_reset_timer ) {
#endif
		cancel_rc5_reception();
	} else {
		unsigned char level = PORTname(IR_PIN_PORT,IR_INPUT_PIN);
		rc5_code <<= 1;
		rc5_code |= level != 0;
		if( ++ir_bit == 15 ) {
			rc5_code >>= 1;
			ir_final_code = RC5((rc5_code&0x7FF)|(rc5_code == last_rc5_code ? IR_REPEAT : 0));
			last_rc5_code = rc5_code;
			cancel_rc5_reception();
		} else {
			PRname(IR_TIMER) = rc5_timing + (rc5_timing>>1);
			rc5_reset_timer = 1;
		}
	}
}

void __attribute__((__interrupt__,no_auto_psv)) _CNInterrupt(void) {
	IFS1bits.CNIF = 0;

    if( ir_bit <= 1 ) {
		if( ir_bit == 0 ) {
			if( !PORTname(IR_PIN_PORT,IR_INPUT_PIN) ) {
//          For some reason this causes problems with the Digital Audio Delay; the audio drops out during IR activity.
//          Since the clock rate doesn't change in this application, this only needs to be calculated once anyway.
//			if( ir_CLKDIV_cache != CLKDIV || ir_PLLFBD_cache != PLLFBD )
//				calc_rc5_timing();
			// start reception
#ifdef SUPPORT_NEC
				PRname(IR_TIMER) = NEC_startpulse_max;
#else
				PRname(IR_TIMER) = RC5_MAX;
#endif
				start_ir_timer();
				rc5_reset_timer = 0;
				ir_bit = 1;
				rc5_code = 0;
			}
		} else {
			if( !PORTname(IR_PIN_PORT,IR_INPUT_PIN) ) {
				rc5_timing = TIMERname(IR_TIMER);
				cancel_rc5_reception();
				if( rc5_timing >= RC5_MIN && rc5_timing <= RC5_MAX ) {
					unsigned short temp = rc5_timing>>1;
					PRname(IR_TIMER) = (temp) + (temp>>1);
					start_ir_timer();
		        	ir_bit = 2;
				}
#ifdef SUPPORT_NEC
			} else if( TIMERname(IR_TIMER) >= NEC_startpulse_min ) {
				rc5_timing = TIMERname(IR_TIMER)>>1;
				stop_ir_timer();
				PRname(IR_TIMER) = rc5_timing + (rc5_timing>>2);
				start_ir_timer();
	        	ir_bit = 31;
#endif
			}
		}
#ifdef SUPPORT_NEC
	} else if( ir_bit >= 31 ) {
		if( ir_bit == 31 && !PORTname(IR_PIN_PORT,IR_INPUT_PIN) ) {
			if( TIMERname(IR_TIMER) >= rc5_timing - (rc5_timing>>2) ) {
				// start NECernative IR reception
				stop_ir_timer();
				PRname(IR_TIMER) = (rc5_timing>>3) + (rc5_timing>>4);
				start_ir_timer();
				NEC_code = 0;
		        ir_bit = 32;
			} else if( TIMERname(IR_TIMER) >= (rc5_timing>>2) + (rc5_timing>>3) ) {
				ir_final_code = IR_REPEAT|NEC(last_NEC_code);
				cancel_rc5_reception();
			} else {
				cancel_rc5_reception();
			}
		} else {
			if( PORTname(IR_PIN_PORT,IR_INPUT_PIN) ) {
				stop_ir_timer();
				PRname(IR_TIMER) = (rc5_timing>>2) + (rc5_timing>>3) + (rc5_timing>>4);
				start_ir_timer();
			} else {
				NEC_code <<= 1;
				NEC_code |= TIMERname(IR_TIMER) >= (rc5_timing>>3) + (rc5_timing>>4);
				++ir_bit;

				if( ir_bit == 64 ) {
					union {
						unsigned long l;
						unsigned char b[4];
					} temp;
					temp.l = NEC_code;
					cancel_rc5_reception();
					if( temp.b[0] == 0xFF-temp.b[1] && temp.b[2] == 0xFF-temp.b[3] ) {
						last_NEC_code = temp.b[1]|(((unsigned short)temp.b[3])<<8);
						ir_final_code = NEC(last_NEC_code);
					}
				} else {
					stop_ir_timer();
					PRname(IR_TIMER) = (rc5_timing>>3) + (rc5_timing>>4);
					start_ir_timer();
				}
			}
		}
#endif
	} else if( rc5_reset_timer ) {
		unsigned short temp = rc5_timing>>1;
		TIMERname(IR_TIMER) = 0;
		PRname(IR_TIMER) = (temp) + (temp>>1);
		rc5_reset_timer = 0;
	}
}
